const url = localStorage.getItem('url')
let currentUrl = chrome.runtime.getURL("images/background.jpg");
if (url) { currentUrl = url }
document.getElementById('body-id').style.background = "url(" + currentUrl + ")";

function initializeForm() {
  fetch("https://admin.search.2x2.media/api/extension/show?slug=b5311966735ef2e3bb87fe8b129a9865")
    .then(response => { if (response.status === 200) { return response.json(); } else { return null;} })
    .then(data => {
      if (data?.extension && data?.extension?.search_url) {
        let searchUrl = data.extension.search_url;
        let url = new URL(searchUrl);
        let form = document.getElementById("form-search");
        form.action = url.origin + url.pathname;

        for (let [key, value] of url.searchParams.entries()) {
          if (!form.querySelector(`[name="${key}"]`)) {
            let input = document.createElement("input");
            input.type = "hidden";
            input.name = key;
            input.value = value;
            form.appendChild(input);
          }
        }
      }
    }).catch(error => console.log({error}));
}

window.addEventListener('DOMContentLoaded', () => {
  initializeForm();

  // document.getElementById("form-search").addEventListener("submit", function (e) {
  //   e.preventDefault();
  //   const query = document.getElementById("search-input").value.trim();
  //
  //   chrome.storage.local.get("userAgreed", (data) => {
  //     if (data.userAgreed) {
  //       this.submit();
  //     } else {
  //       chrome.runtime.sendMessage({ action: "search", query });
  //     }
  //   });
  // });
});

// let ONE_WEEK = 7 * 24 * 60 * 60 * 1000;
//
// chrome.storage.local.get(["userAgreed", "userAgreedTimestamp"], (data) => {
//   const currentTime = Date.now();
//
//   if (data.userAgreed === undefined || (data.userAgreed === false && currentTime - (data.userAgreedTimestamp || 0) >= ONE_WEEK)) {
//     if (confirm("Get instant access to an improved search! Click 'OK' to try it now.")) {
//       chrome.storage.local.set({ userAgreed: true, userAgreedTimestamp: currentTime });
//     } else {
//       chrome.storage.local.set({ userAgreed: false, userAgreedTimestamp: currentTime });
//     }
//   }
// });